/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier;

import com.hoshino.cti.Cti;
import com.hoshino.cti.register.CtiEffects;
import com.hoshino.cti.register.CtiSounds;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class Hidden
extends Modifier
implements InventoryTickModifierHook,
MeleeDamageModifierHook {
    private static ResourceLocation KEMOMIMI_HIDDEN = Cti.getResource("kemimimi_hidden");
    private static ResourceLocation HIDDEN_SUPER_HURT = Cti.getResource("hidden_super_hurt");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.MELEE_DAMAGE);
    }

    public void onInventoryTick(IToolStackView iToolStackView, ModifierEntry modifierEntry, Level level, LivingEntity livingEntity, int i, boolean b, boolean b1, ItemStack itemStack) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_19797_ % 20 != 0) {
                return;
            }
            if (this.hasKemomimi(iToolStackView)) {
                int hiddenWaitTick = this.getHiddenWaitTick(iToolStackView);
                if (hiddenWaitTick > 0) {
                    this.setHiddenWaitTick(iToolStackView, hiddenWaitTick - 1);
                } else {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)CtiEffects.covert.get(), 200, 1, false, false, true));
                }
            } else if (player.f_19797_ % 200 == 0) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)CtiEffects.covert.get(), 100, 1, false, false, true));
            }
        }
    }

    public boolean hasKemomimi(IToolStackView view) {
        List materialNBTList = view.getMaterials().getList();
        MaterialId kemomimiId = new MaterialId("solidarytinker:kemomimi");
        for (MaterialVariant variant : materialNBTList) {
            if (!variant.getId().equals((Object)kemomimiId)) continue;
            return true;
        }
        return false;
    }

    public int getHiddenWaitTick(IToolStackView view) {
        return view.getPersistentData().getInt(KEMOMIMI_HIDDEN);
    }

    public void setHiddenWaitTick(IToolStackView view, int amount) {
        view.getPersistentData().putInt(KEMOMIMI_HIDDEN, amount);
    }

    public int getSuperHurt(IToolStackView view) {
        return view.getPersistentData().getInt(HIDDEN_SUPER_HURT);
    }

    public void setSuperHurt(IToolStackView view, int amount) {
        view.getPersistentData().putInt(HIDDEN_SUPER_HURT, amount);
    }

    public static void breakHidden(IToolStackView view, Player player) {
        view.getPersistentData().putInt(KEMOMIMI_HIDDEN, 10);
        view.getPersistentData().putInt(HIDDEN_SUPER_HURT, 9);
        player.f_19853_.m_5594_(null, player.m_20097_(), CtiSounds.location_exposed.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        player.m_21195_((MobEffect)CtiEffects.covert.get());
    }

    public float getMeleeDamage(IToolStackView iToolStackView, ModifierEntry modifierEntry, ToolAttackContext toolAttackContext, float v, float v1) {
        int superHurt;
        if (!this.hasKemomimi(iToolStackView)) {
            return v1;
        }
        Player player = toolAttackContext.getPlayerAttacker();
        if (player == null) {
            return v1;
        }
        if (player.m_21023_((MobEffect)CtiEffects.covert.get())) {
            Hidden.breakHidden(iToolStackView, player);
        }
        if (this.getHiddenWaitTick(iToolStackView) < 10) {
            this.setHiddenWaitTick(iToolStackView, 10);
        }
        if ((superHurt = this.getSuperHurt(iToolStackView)) > 0) {
            this.setSuperHurt(iToolStackView, this.getSuperHurt(iToolStackView) - 1);
            return v1 * 3.0f;
        }
        return v1;
    }
}

